#
#	MBsysTran - Release 8.1
#
#	Copyright 
#	Universite catholique de Louvain (UCLouvain) 
#	Mechatronic, Electrical Energy, and Dynamic systems (MEED Division) 
#	2, Place du Levant
#	1348 Louvain-la-Neuve 
#	Belgium 
#
#	http://www.robotran.be 
#
#	==> Generation Date: Wed Apr 20 17:10:05 2022
#
#	==> Project name: five_point_suspension_c
#
#	==> Number of joints: 16
#
#	==> Function: F19 - External Forces
#
#	==> Git hash: 220d76a94da8547597795a13c9921f0375de3fc1
#

from math import sin, cos, sqrt
from numpy import zeros

def extforces(frc, trq, s, tsim):
    q = s.q
    qd = s.qd
    qdd = s.qdd
    frc = s.frc
    trq = s.trq
    PxF1 = zeros(4)
    RxF1 = zeros((4, 4))
    VxF1 = zeros(4)
    OMxF1 = zeros(4)
    AxF1 = zeros(4)
    OMPxF1 = zeros(4)

 
# Trigonometric functions

    S10 = sin(q[10])
    C10 = cos(q[10])
    S11 = sin(q[11])
    C11 = cos(q[11])
    S12 = sin(q[12])
    C12 = cos(q[12])
    S13 = sin(q[13])
    C13 = cos(q[13])
    S14 = sin(q[14])
    C14 = cos(q[14])
    S15 = sin(q[15])
    C15 = cos(q[15])
 
# Augmented Joint Position Vectors

 
# Sensor Kinematics

    ROcp2_211 = C10*S11
    ROcp2_311 = S10*S11
    ROcp2_511 = C10*C11
    ROcp2_611 = S10*C11
    ROcp2_412 = -S11*C12
    ROcp2_512 = ROcp2_511*C12-S10*S12
    ROcp2_612 = ROcp2_611*C12+C10*S12
    ROcp2_712 = S11*S12
    ROcp2_812 = -ROcp2_511*S12-S10*C12
    ROcp2_912 = -ROcp2_611*S12+C10*C12
    ROcp2_113 = -ROcp2_712*S13+C11*C13
    ROcp2_213 = ROcp2_211*C13-ROcp2_812*S13
    ROcp2_313 = ROcp2_311*C13-ROcp2_912*S13
    ROcp2_713 = ROcp2_712*C13+C11*S13
    ROcp2_813 = ROcp2_211*S13+ROcp2_812*C13
    ROcp2_913 = ROcp2_311*S13+ROcp2_912*C13
    ROcp2_114 = ROcp2_113*C14+ROcp2_412*S14
    ROcp2_214 = ROcp2_213*C14+ROcp2_512*S14
    ROcp2_314 = ROcp2_313*C14+ROcp2_612*S14
    ROcp2_414 = -ROcp2_113*S14+ROcp2_412*C14
    ROcp2_514 = -ROcp2_213*S14+ROcp2_512*C14
    ROcp2_614 = -ROcp2_313*S14+ROcp2_612*C14
    ROcp2_115 = ROcp2_114*C15-ROcp2_713*S15
    ROcp2_215 = ROcp2_214*C15-ROcp2_813*S15
    ROcp2_315 = ROcp2_314*C15-ROcp2_913*S15
    ROcp2_715 = ROcp2_114*S15+ROcp2_713*C15
    ROcp2_815 = ROcp2_214*S15+ROcp2_813*C15
    ROcp2_915 = ROcp2_314*S15+ROcp2_913*C15
    POcp2_32 = q[1]+s.dpt[3,6]
    OMcp2_23 = -qd[11]*S10
    OMcp2_33 = qd[11]*C10
    OPcp2_23 = -qd[10]*qd[11]*C10-qdd[11]*S10
    OPcp2_33 = -qd[10]*qd[11]*S10+qdd[11]*C10
    RLcp2_14 = -s.dpt[2,12]*S11
    RLcp2_24 = ROcp2_511*s.dpt[2,12]
    RLcp2_34 = ROcp2_611*s.dpt[2,12]
    POcp2_14 = RLcp2_14+s.dpt[1,6]
    POcp2_24 = RLcp2_24+s.dpt[2,6]
    POcp2_34 = POcp2_32+RLcp2_34
    OMcp2_14 = qd[10]+qd[12]*C11
    OMcp2_24 = OMcp2_23+qd[12]*ROcp2_211
    OMcp2_34 = OMcp2_33+qd[12]*ROcp2_311
    ORcp2_14 = OMcp2_23*RLcp2_34-OMcp2_33*RLcp2_24
    ORcp2_24 = -qd[10]*RLcp2_34+OMcp2_33*RLcp2_14
    ORcp2_34 = qd[10]*RLcp2_24-OMcp2_23*RLcp2_14
    VIcp2_34 = qd[1]+ORcp2_34
    OPcp2_14 = qdd[10]+qd[12]*(OMcp2_23*ROcp2_311-OMcp2_33*ROcp2_211)+qdd[12]*C11
    OPcp2_24 = OPcp2_23+qd[12]*(-qd[10]*ROcp2_311+OMcp2_33*C11)+qdd[12]*ROcp2_211
    OPcp2_34 = OPcp2_33+qd[12]*(qd[10]*ROcp2_211-OMcp2_23*C11)+qdd[12]*ROcp2_311
    ACcp2_14 = OMcp2_23*ORcp2_34-OMcp2_33*ORcp2_24+OPcp2_23*RLcp2_34-OPcp2_33*RLcp2_24
    ACcp2_24 = -qd[10]*ORcp2_34-qdd[10]*RLcp2_34+OMcp2_33*ORcp2_14+OPcp2_33*RLcp2_14
    ACcp2_34 = qdd[1]+qd[10]*ORcp2_24+qdd[10]*RLcp2_24-OMcp2_23*ORcp2_14-OPcp2_23*RLcp2_14
    OMcp2_15 = OMcp2_14+qd[13]*ROcp2_412
    OMcp2_25 = OMcp2_24+qd[13]*ROcp2_512
    OMcp2_35 = OMcp2_34+qd[13]*ROcp2_612
    OPcp2_15 = OPcp2_14+qd[13]*(OMcp2_24*ROcp2_612-OMcp2_34*ROcp2_512)+qdd[13]*ROcp2_412
    OPcp2_25 = OPcp2_24+qd[13]*(-OMcp2_14*ROcp2_612+OMcp2_34*ROcp2_412)+qdd[13]*ROcp2_512
    OPcp2_35 = OPcp2_34+qd[13]*(OMcp2_14*ROcp2_512-OMcp2_24*ROcp2_412)+qdd[13]*ROcp2_612
    OMcp2_16 = OMcp2_15+qd[14]*ROcp2_713
    OMcp2_26 = OMcp2_25+qd[14]*ROcp2_813
    OMcp2_36 = OMcp2_35+qd[14]*ROcp2_913
    OPcp2_16 = OPcp2_15+qd[14]*(OMcp2_25*ROcp2_913-OMcp2_35*ROcp2_813)+qdd[14]*ROcp2_713
    OPcp2_26 = OPcp2_25+qd[14]*(-OMcp2_15*ROcp2_913+OMcp2_35*ROcp2_713)+qdd[14]*ROcp2_813
    OPcp2_36 = OPcp2_35+qd[14]*(OMcp2_15*ROcp2_813-OMcp2_25*ROcp2_713)+qdd[14]*ROcp2_913
    RLcp2_17 = ROcp2_114*s.dpt[1,14]+ROcp2_414*s.dpt[2,14]+ROcp2_713*s.dpt[3,14]
    RLcp2_27 = ROcp2_214*s.dpt[1,14]+ROcp2_514*s.dpt[2,14]+ROcp2_813*s.dpt[3,14]
    RLcp2_37 = ROcp2_314*s.dpt[1,14]+ROcp2_614*s.dpt[2,14]+ROcp2_913*s.dpt[3,14]
    POcp2_17 = POcp2_14+RLcp2_17
    POcp2_27 = POcp2_24+RLcp2_27
    POcp2_37 = POcp2_34+RLcp2_37
    OMcp2_17 = OMcp2_16+qd[15]*ROcp2_414
    OMcp2_27 = OMcp2_26+qd[15]*ROcp2_514
    OMcp2_37 = OMcp2_36+qd[15]*ROcp2_614
    ORcp2_17 = OMcp2_26*RLcp2_37-OMcp2_36*RLcp2_27
    ORcp2_27 = -OMcp2_16*RLcp2_37+OMcp2_36*RLcp2_17
    ORcp2_37 = OMcp2_16*RLcp2_27-OMcp2_26*RLcp2_17
    VIcp2_17 = ORcp2_14+ORcp2_17
    VIcp2_27 = ORcp2_24+ORcp2_27
    VIcp2_37 = ORcp2_37+VIcp2_34
    OPcp2_17 = OPcp2_16+qd[15]*(OMcp2_26*ROcp2_614-OMcp2_36*ROcp2_514)+qdd[15]*ROcp2_414
    OPcp2_27 = OPcp2_26+qd[15]*(-OMcp2_16*ROcp2_614+OMcp2_36*ROcp2_414)+qdd[15]*ROcp2_514
    OPcp2_37 = OPcp2_36+qd[15]*(OMcp2_16*ROcp2_514-OMcp2_26*ROcp2_414)+qdd[15]*ROcp2_614
    ACcp2_17 = ACcp2_14+OMcp2_26*ORcp2_37-OMcp2_36*ORcp2_27+OPcp2_26*RLcp2_37-OPcp2_36*RLcp2_27
    ACcp2_27 = ACcp2_24-OMcp2_16*ORcp2_37+OMcp2_36*ORcp2_17-OPcp2_16*RLcp2_37+OPcp2_36*RLcp2_17
    ACcp2_37 = ACcp2_34+OMcp2_16*ORcp2_27-OMcp2_26*ORcp2_17+OPcp2_16*RLcp2_27-OPcp2_26*RLcp2_17
    PxF1[1] = POcp2_17
    PxF1[2] = POcp2_27
    PxF1[3] = POcp2_37
    RxF1[1,1] = ROcp2_115
    RxF1[1,2] = ROcp2_215
    RxF1[1,3] = ROcp2_315
    RxF1[2,1] = ROcp2_414
    RxF1[2,2] = ROcp2_514
    RxF1[2,3] = ROcp2_614
    RxF1[3,1] = ROcp2_715
    RxF1[3,2] = ROcp2_815
    RxF1[3,3] = ROcp2_915
    VxF1[1] = VIcp2_17
    VxF1[2] = VIcp2_27
    VxF1[3] = VIcp2_37
    OMxF1[1] = OMcp2_17
    OMxF1[2] = OMcp2_27
    OMxF1[3] = OMcp2_37
    AxF1[1] = ACcp2_17
    AxF1[2] = ACcp2_27
    AxF1[3] = ACcp2_37
    OMPxF1[1] = OPcp2_17
    OMPxF1[2] = OPcp2_27
    OMPxF1[3] = OPcp2_37
 
# Sensor Forces 

    SWr1 = s.user_ExtForces(PxF1,RxF1,VxF1,OMxF1,AxF1,OMPxF1,s,tsim,1)
    xfrc12 = RxF1[1,1]*SWr1[1]+RxF1[1,2]*SWr1[2]+RxF1[1,3]*SWr1[3]
    xfrc22 = RxF1[2,1]*SWr1[1]+RxF1[2,2]*SWr1[2]+RxF1[2,3]*SWr1[3]
    xfrc32 = RxF1[3,1]*SWr1[1]+RxF1[3,2]*SWr1[2]+RxF1[3,3]*SWr1[3]
    xtrq12 = RxF1[1,1]*SWr1[4]+RxF1[1,2]*SWr1[5]+RxF1[1,3]*SWr1[6]
    xtrq22 = RxF1[2,1]*SWr1[4]+RxF1[2,2]*SWr1[5]+RxF1[2,3]*SWr1[6]
    xtrq32 = RxF1[3,1]*SWr1[4]+RxF1[3,2]*SWr1[5]+RxF1[3,3]*SWr1[6]
    trqext_1_15_1 = xtrq12-xfrc22*SWr1[9]+xfrc32*SWr1[8]
    trqext_2_15_1 = xtrq22+xfrc12*SWr1[9]-xfrc32*SWr1[7]
    trqext_3_15_1 = xtrq32-xfrc12*SWr1[8]+xfrc22*SWr1[7]
 
# Symbolic model output

    frc[1,15] = s.frc[1,15]+xfrc12
    frc[2,15] = s.frc[2,15]+xfrc22
    frc[3,15] = s.frc[3,15]+xfrc32
    trq[1,15] = s.trq[1,15]+trqext_1_15_1
    trq[2,15] = s.trq[2,15]+trqext_2_15_1
    trq[3,15] = s.trq[3,15]+trqext_3_15_1

# Number of continuation lines = 0


